DROP PROCEDURE [hips].[PatientMasterIhiDelete]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon
-- Create date: 25 July 2012
-- Description:   Deletes an existing record from the PatientMasterIhi Table
-- =============================================
CREATE PROCEDURE [hips].[PatientMasterIhiDelete]
(
@PatientMasterId INT
)
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @intErrorCode INT,
	@intRowsAffected INT
	SELECT  @intErrorCode = 0,
			@intRowsAffected = 0
	DELETE
		[hips].[PatientMasterIhi]
	WHERE [PatientMasterId] = @PatientMasterId
	
	SELECT @intErrorCode = @@ERROR,
	@intRowsAffected = @@ROWCOUNT
	
	SELECT @intRowsAffected AS RowsAffected
	RETURN(@intErrorCode)
END
GO

